# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 6
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR6_strategy.txt
# LLM Suggested Fallback: D

def harmony_trust_optimizer_v6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "C") / max(1, len(opp_history))
    peace_counter = sum(1 for move in my_history if move == "C")
    
    # Initial Trust-Building Phase (Rounds 1-2)
    if current_round <= 2:
        return "C"
    
    # Probing Defection in Round 3
    elif current_round == 3:
        return "D"
    
    # Mid-Game Exploitation (Rounds 4-6)
    elif 4 <= current_round <= 6:
        if current_round == 4:
            if opp_history[-1] == "C":
                return "D" if random.random() < 0.3 else "C"
            else:
                return "D"
        elif current_round == 5:
            if opp_history[-1] == "C":
                return "C" if random.random() < 0.7 else "D"
            else:
                return "D"
        elif current_round == 6:
            if len(opp_history) >= 4 and opp_history[-2] == "D" and opp_history[-1] == "C":
                return "D"
            else:
                return "D" if opp_history[-1] == "D" else "C"
    
    # Late-Game Aggression (Rounds 7-9)
    elif 7 <= current_round <= 9:
        if trust_score > 0.6:
            return "D"
        elif trust_score < 0.4:
            return "D" if current_round % 2 == 0 else "C"
        else:
            return "D" if random.random() < 0.7 else "C"
    
    # Final Round (Round 10)
    elif current_round == 10:
        return "D"
    
    # Fallback (shouldn't happen in 10-round match)
    return "C"